from textual.widgets import TabPane, Markdown
from textual.app import ComposeResult
from . import config

import os

class About(TabPane):
    def __init__(self, title, *children, name = None, id = None, classes = None, disabled = False):
        super().__init__(title, *children, name=name, id=id, classes=classes, disabled=disabled)
        with open(os.path.join(config.ABSOLUTE_PROGRAM_PATH, "res/about.md"), encoding="utf-8") as f:
            self.markdown = f.read()
    
    def compose(self) -> ComposeResult:
        yield Markdown(self.markdown, id="abt_md")
    
    def on_show(self) -> None:
        md = self.query_one("#abt_md", Markdown)