import json
import os

CONFIG_PATH = os.path.join(os.path.split(__file__)[0], "./session.json")
ABSOLUTE_PROGRAM_PATH = os.path.split(__file__)[0]

SETTINGS = {}

def save_config(data):
    with open(CONFIG_PATH, "w") as f:
        json.dump(data, f)
    
    SETTINGS.clear()
    SETTINGS.update(data)

def load_config() -> dict:
    if os.path.exists(CONFIG_PATH):
        with open(CONFIG_PATH) as f:
            SETTINGS.clear()
            SETTINGS.update(json.load(f))
            
    return SETTINGS