from textual.app import App, ComposeResult
from textual.widgets import Header, TabbedContent, TabPane, Static, Input, TextArea, Button, Label, Rule
from textual.containers import Container, VerticalScroll
from .settings import Settings
from .new_dhcp_mapping import New_DHCP_Mapping
from .mappings_list import DHCP_Mapping_List
from .about import About
from . import config
import os

class Main(App):
    CSS_PATH = ["css/main.tcss", "css/settings.tcss", "css/new_dhcp_mapping.tcss", "css/mappings_list.tcss"]
    
    def __init__(self, driver_class = None, css_path = None, watch_css = False, ansi_color = False):
        super().__init__(driver_class, css_path, watch_css, ansi_color)
    
    def on_mount(self):
        if os.path.exists(config.CONFIG_PATH):
            config.load_config()
    
    def compose(self) -> ComposeResult:
        yield Header()
        with TabbedContent():
            
            yield New_DHCP_Mapping("Új DHCP foglalások")
            yield DHCP_Mapping_List("DHCP foglalások")
            yield Settings("Beállítások")
            yield About("About")

if __name__ == "__main__":
    import sys 
    sys.exit(Main(watch_css=True).run())