from textual.containers import Container, Horizontal, VerticalScroll
from textual.widgets import Static, Input, TextArea, Button, Label, Rule, Checkbox, Switch, TabPane
from .network import parse_keys
from .network_types import *
import os
import json
from . import config

class Settings(TabPane):

    def __init__(self, title, *children, name = None, id = None, classes = None, disabled = False):
        super().__init__(title, *children, name=name, id=id, classes=classes, disabled=disabled)
        
    
    def on_mount(self):
        if os.path.exists(config.CONFIG_PATH):
            config.load_config()
        
        if config.SETTINGS:
            self.query_one("#st_api_keys", TextArea).text = \
                f"key={config.SETTINGS.get("k")}\n" + \
                f"secret={config.SETTINGS.get("s")}\n"
            
            self.query_one("#st_opnsense_url", Input).value = config.SETTINGS.get("u")

            self.query_one("#st_debug_enabled", Switch).value = config.SETTINGS.get("d")
          
    def compose(self):
        
        with Container(classes="title_container"):
            yield Label("Beállítások", id="dhcp_title")
        yield Rule()
            
        with VerticalScroll(id="st_content_container"):
            yield Static("API kulcs:")
            text = TextArea(id="st_api_keys", line_number_start=0, show_line_numbers=True)
            text.text = "key=xxxxxxxxx\nsecret=xxxxxxxxx"
            yield text
            
            yield Static("OPNsense webcím (pl: https://172.16.0.1/):", classes="top-space")
            yield Input(id="st_opnsense_url")
            
            with Horizontal(classes="top-space"):
                yield Label("Debug ")
                yield Switch(id="st_debug_enabled")
            
            yield Button("Mentés", id="st_save_button")
            
    
    def on_button_pressed(self, event: Button.Pressed):
        if event.button.id == "st_save_button":
            key, secret = parse_keys(self.query_one("#st_api_keys", TextArea).text)
            url = self.query_one("#st_opnsense_url", Input).value
            debug = self.query_one("#st_debug_enabled", Switch).value
            save = {
                "k": key,
                "s": secret,
                "u": url,
                "d": debug
            }
            
            config.save_config(save)
        
        